/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.dialog.comp.display.ActualValueSelectionPanel;
import DE.siemens.ad.logo.dialog.comp.display.ScaleTimeDisplayElement;
import DE.siemens.ad.logo.model.TimeBase;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.panel.StopWatchPanel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.ProgramException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ScaleTimeSettingPanel
extends DataInputPanel {
    private static final long serialVersionUID = 1L;
    private WiringDiagram fWD;
    private ActualValueSelectionPanel paramSelectPanel;
    private ScaleTimeDisplayElement fScaleTime;
    private JComboBox fTimeBaseCombo = null;

    public ScaleTimeSettingPanel(WiringDiagram wd, ScaleTimeDisplayElement scaleTime) {
        this.fWD = wd;
        this.fScaleTime = scaleTime;
        this.initialize();
    }

    private void initialize() {
        this.setName(Language.getString("dialog.parameter.message.setScaleTimeTitle", "ScaleTime Setting"));
        this.setBounds(0, 0, 600, 400);
        this.setLayout(new BorderLayout());
        this.setSize(280, 300);
        this.add((Component)this.getBarSelectPanel(), "Center");
    }

    private JPanel getBarSelectPanel() {
        if (null == this.paramSelectPanel) {
            this.paramSelectPanel = new ActualValueSelectionPanel(this.fWD);
        }
        JLabel timeBaseLabel = new JLabel(Language.getString("dialog.parameter.stopwatch.timebase", "Time base") + ": ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 0, 4);
        this.paramSelectPanel.add((Component)timeBaseLabel, gbc);
        this.fTimeBaseCombo = new JComboBox();
        DefaultComboBoxModel<TimeBase> comboBoxModel = new DefaultComboBoxModel<TimeBase>(TimeBase.getDefaultTimeBases());
        this.fTimeBaseCombo.setModel(comboBoxModel);
        this.fTimeBaseCombo.setRenderer(new StopWatchPanel.TimeBaseListCellRender());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 2.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 0, 0, 4);
        this.paramSelectPanel.add((Component)this.fTimeBaseCombo, gbc);
        return this.paramSelectPanel;
    }

    public boolean isAvailable() {
        return this.paramSelectPanel.isAvailable();
    }

    public boolean checkFieldContents() {
        return this.paramSelectPanel.getParameterItem() != null;
    }

    public void loadFieldContents() throws ProgramException {
        this.paramSelectPanel.setParameterItem(this.fScaleTime.getParameterItem());
        ComboBoxModel comboBoxModel = this.fTimeBaseCombo.getModel();
        int modelSize = comboBoxModel.getSize();
        for (int i = 0; i < modelSize; ++i) {
            if (((TimeBase)comboBoxModel.getElementAt(i)).getTimeBaseKey() != this.fScaleTime.getTimeBase()) continue;
            this.fTimeBaseCombo.setSelectedIndex(i);
        }
    }

    public void storeFieldContents() {
        this.fScaleTime.setParameterItem(this.paramSelectPanel.getParameterItem());
        this.fScaleTime.setTimeBase(((TimeBase)this.fTimeBaseCombo.getSelectedItem()).getTimeBaseKey());
    }
}

